/** VKT, FUEL CONSUMPTION & TRAVEL COSTS MODEL*/

/** DIMENSIONS*/
/*Projection length, periods*/
/* DIMENSIONS*/
mata
Ps = 2021
Pe = 2050
/*Projection_t = 2021:2050
//Length of historical data series*/
Ts = 1992
Te = 2020
/*Set population series length, history plus projection
*Time_t = 1992:2050*/
Time_length = Pe - Ts + 1
TL = Time_length
Time_t = 1992..2050
/*Length of history
*History_length = length(History_t)*/
History_length = Te - Ts+1
HL = History_length
Fleet_projection = 2021..2050
VKT_t = 2001..2050
VKT_time_length = length(VKT_t)
VKT_projection = 2021..2050
TL_fleet = length(Fleet_t)
PL_fleet = length(Fleet_projection)
TL_vkt = length(VKT_t)
fleet_input_t = 2000..2020
IL_fleet = cols(fleet_input_t)
PL_fleet = length(Fleet_projection)+1 /*Fleet Projection length (PL)*/
veh_ages_l = (cols(lpv_input))/*Vehicle type and age dimensions*/
veh_ages_str=0..44
	veh_ages_n=length(veh_ages_str)
VKT_input_t = 2001..2020
IL_vkt = length(VKT_input_t)
PL_vkt = length(VKT_projection)
IL_fiscal = 29 /*This is upto 2020*/
Fiscal_projection = 2021..2050
		PL_fiscal = length(Fiscal_projection)
TL_fiscal = Time_length
/** Travel by HH dimensions*/
panel_input_t = length(2004..2020)
panel_backcast = length(1992..2003)
panel_forecast = length(2021..2050)
/*Vehicle type and age dimensions*/
veh_ages_l = (cols(lpv_input))/*Vehicle type and age dimensions*/
veh_ages_str=0..44
lpv_types = rows(lpv_input)/IL_fleet
lcv_types = rows(lcv_input)/IL_fleet
mc_types = rows(mc_input)/IL_fleet
hcv_types = rows(hcv_input)/IL_fleet
bus_types = rows(bus_input)/IL_fleet 
veh_ages_minus_one = veh_ages-1 
VKT_ages = (0..(cols(vkt_input)-1))
VKT_ages_n = length(VKT_ages)

/** PARAMETERS*/
/* Most parameters (fuel efficiency etc enter via input data). The only*/
/* exception is emission factors (all in g/l).*/
diesel_co2_factor = 2650.7509
diesel_ch4_factor = 0.1461
diesel_n2o_factor = 0.1425
diesel_co_factor = 11.6523
diesel_nox_factor = 24.7291
diesel_nmvoc_factor = 3.9084
diesel_so2_factor = 4.0139
petrol_co2_factor = 2311.7949
petrol_ch4_factor = 0.6497
petrol_n2o_factor = 0.0500 
petrol_co_factor = 161.0186
petrol_nox_factor = 7.3963
petrol_nmvoc_factor= 31.0343
petrol_so2_factor = 0.0747

/** INITIALISE*/

/*Extract input data (this is not automated via parameters simply because*/
/*the text for this turned out to be large and confusing to look at but this*/
/*will slow any updating and may need to be rectified depending on future*/
/*model uses/extensions*/
/*load('travel_panel.mat')*/

lpv_vkt_input = vkt_input[1..(lpv_types*IL_vkt),.]
lcv_vkt_input = vkt_input[(lpv_types*IL_vkt)+1..((lpv_types*IL_vkt)*2),.]
mc_vkt_input = vkt_input[((lpv_types*IL_vkt)*2)+1..((lpv_types*IL_vkt)*2)+(mc_types*IL_vkt),.]
hcv_vkt_input = vkt_input[((lpv_types*IL_vkt)*2)+(mc_types*IL_vkt)+1..((lpv_types*IL_vkt)*2)+(mc_types*IL_vkt)+(hcv_types*IL_vkt),.]
bus_vkt_input = vkt_input[((lpv_types*IL_vkt)*2)+(mc_types*IL_vkt)+(hcv_types*IL_vkt)+1..((lpv_types*IL_vkt)*2)+(mc_types*IL_vkt)+(hcv_types*IL_vkt)+(bus_types*IL_vkt),.]

lpv_eff_input = eff_input[1..(lpv_types*IL_fleet),.]
lcv_eff_input = eff_input[(lpv_types*IL_fleet)+1..((lpv_types*IL_fleet)*2),.]
mc_eff_input = eff_input[((lpv_types*IL_fleet)*2)+1..((lpv_types*IL_fleet)*2)+(mc_types*IL_fleet),.]
hcv_eff_input = eff_input[((lpv_types*IL_fleet)*2)+(mc_types*IL_fleet)+1..((lpv_types*IL_fleet)*2)+(mc_types*IL_fleet)+(hcv_types*IL_fleet),.]
bus_eff_input = eff_input[((lpv_types*IL_fleet)*2)+(mc_types*IL_fleet)+(hcv_types*IL_fleet)+1..((lpv_types*IL_fleet)*2)+(mc_types*IL_fleet)+(hcv_types*IL_fleet)+(bus_types*IL_fleet),.]

lpv_ruc_rate_input = ruc_rate_input[1..(lpv_types*IL_fleet),.]
lcv_ruc_rate_input = ruc_rate_input[(lpv_types*IL_fleet)+1..((lpv_types*IL_fleet)*2),.]
mc_ruc_rate_input = ruc_rate_input[((lpv_types*IL_fleet)*2)+1..((lpv_types*IL_fleet)*2)+(mc_types*IL_fleet),.]
hcv_ruc_rate_input = ruc_rate_input[((lpv_types*IL_fleet)*2)+(mc_types*IL_fleet)+1..((lpv_types*IL_fleet)*2)+(mc_types*IL_fleet)+(hcv_types*IL_fleet),.]
bus_ruc_rate_input = ruc_rate_input[((lpv_types*IL_fleet)*2)+(mc_types*IL_fleet)+(hcv_types*IL_fleet)+1..((lpv_types*IL_fleet)*2)+(mc_types*IL_fleet)+(hcv_types*IL_fleet)+(bus_types*IL_fleet),.]

/*Add projection dimensions*/
lpv_vkt_hist = J(IL_vkt,VKT_ages_n*lpv_types,0)
lcv_vkt_hist = J(IL_vkt,VKT_ages_n*lpv_types,0)
mc_vkt_hist = J(IL_vkt,VKT_ages_n*mc_types,0)
hcv_vkt_hist = J(IL_vkt,VKT_ages_n*hcv_types,0)
bus_vkt_hist = J(IL_vkt,VKT_ages_n*bus_types,0)

lpv_eff_hist = J(IL_fleet,veh_ages*lpv_types,0)
lcv_eff_hist = J(IL_fleet,veh_ages*lcv_types,0)
mc_eff_hist = J(IL_fleet,veh_ages*mc_types,0)
hcv_eff_hist = J(IL_fleet,veh_ages*hcv_types,0)
bus_eff_hist = J(IL_fleet,veh_ages*bus_types,0)

lpv_ruc_rate_hist = J(IL_fleet,veh_ages*lpv_types,0)
lcv_ruc_rate_hist = J(IL_fleet,veh_ages*lcv_types,0)
mc_ruc_rate_hist = J(IL_fleet,veh_ages*lcv_types,0)
hcv_ruc_rate_hist = J(IL_fleet,veh_ages*hcv_types,0)
bus_ruc_rate_hist = J(IL_fleet,veh_ages*bus_types,0)

/*Note that we use TL_fleet for projections instead of IL_fleet*/
lpv_cost_perk_proj = J(TL_fleet,veh_ages*lpv_types,0)
lcv_cost_perk_proj = J(TL_fleet,veh_ages*lcv_types,0)
mc_cost_perk_proj = J(TL_fleet,veh_ages*mc_types,0)
hcv_cost_perk_proj = J(TL_fleet,veh_ages*hcv_types,0)
bus_cost_perk_proj = J(TL_fleet,veh_ages*bus_types,0)

lpv_tax_perk_proj = J(TL_fleet,veh_ages*lpv_types,0)
lcv_tax_perk_proj = J(TL_fleet,veh_ages*lcv_types,0)
mc_tax_perk_proj = J(TL_fleet,veh_ages*mc_types,0)
hcv_tax_perk_proj = J(TL_fleet,veh_ages*hcv_types,0)
bus_tax_perk_proj = J(TL_fleet,veh_ages*bus_types,0)


lpv_cost_perk_r_proj = J(TL_fleet,veh_ages*lpv_types,0)
lcv_cost_perk_r_proj = J(TL_fleet,veh_ages*lcv_types,0)
mc_cost_perk_r_proj = J(TL_fleet,veh_ages*mc_types,0)
hcv_cost_perk_r_proj = J(TL_fleet,veh_ages*hcv_types,0)
bus_cost_perk_r_proj = J(TL_fleet,veh_ages*bus_types,0)

lpv_cost_perv_proj = J(TL_fleet,veh_ages*lpv_types,0)
lcv_cost_perv_proj = J(TL_fleet,veh_ages*lcv_types,0)
mc_cost_perv_proj = J(TL_fleet,veh_ages*mc_types,0)
hcv_cost_perv_proj = J(TL_fleet,veh_ages*hcv_types,0)
bus_cost_perv_proj = J(TL_fleet,veh_ages*bus_types,0)


rego = (rego[1..IL_fiscal,1]\J(PL_fiscal,1,0))
licen = (licen[1..IL_fiscal,1]\J(PL_fiscal,1,0))
fed = (fed[1..IL_fiscal,1]\J(PL_fiscal,1,0))
ruc = (ruc[1..IL_fiscal,1]\J(PL_fiscal,1,0))
nltf = (nltf[1..IL_fiscal,1]\J(PL_fiscal,1,0))

/*Fill data in multi-dimensional arrays (t by age by type)*/
/*LPV*/

for (i=1; i< lpv_types; i++){
	lpv_vkt_hist[1..IL_vkt,(i-1)* VKT_ages_n+1..i*VKT_ages_n] = lpv_vkt_input[(i-1)*IL_vkt+1..i*IL_vkt,.]
	lpv_eff_hist[1..IL_vkt,(i-1)* VKT_ages_n+1..i*VKT_ages_n] = lpv_eff_input[(i-1)*IL_vkt+1..i*IL_vkt,.]
	lpv_ruc_rate_hist [1..IL_vkt,(i-1)* VKT_ages_n+1..i*VKT_ages_n] = lpv_ruc_rate_input[(i-1)*IL_vkt+1..i*IL_vkt,.]
}
lpv_eff_hist[.,12*VKT_ages_n+1..13*VKT_ages_n]=J(rows(lpv_eff_hist),VKT_ages_n , elec_eff_initial)
/*LCV */
for (i=1; i< lcv_types; i++){
	lcv_vkt_hist[1..IL_vkt,(i-1)* VKT_ages_n+1..i*VKT_ages_n] = lcv_vkt_input[(i-1)*IL_vkt+1..i*IL_vkt,.]
	lcv_eff_hist[1..IL_vkt,(i-1)* VKT_ages_n+1..i*VKT_ages_n] = lcv_eff_input[(i-1)*IL_vkt+1..i*IL_vkt,.]
	lcv_ruc_rate_hist [1..IL_vkt,(i-1)* VKT_ages_n+1..i*VKT_ages_n] = lcv_ruc_rate_input[(i-1)*IL_vkt+1..i*IL_vkt,.]
}
lcv_eff_hist[.,12*VKT_ages_n+1..13*VKT_ages_n]=J(rows(lcv_eff_hist),VKT_ages_n , elec_eff_initial)

/*MC*/
for (i=1; i< mc_types; i++){
	mc_vkt_hist[1..IL_vkt,(i-1)* VKT_ages_n+1..i*VKT_ages_n] = mc_vkt_input[(i-1)*IL_vkt+1..i*IL_vkt,.]
	mc_eff_hist[1..IL_vkt,(i-1)* VKT_ages_n+1..i*VKT_ages_n] = mc_eff_input[(i-1)*IL_vkt+1..i*IL_vkt,.]
	mc_ruc_rate_hist [1..IL_vkt,(i-1)* VKT_ages_n+1..i*VKT_ages_n] = mc_ruc_rate_input[(i-1)*IL_vkt+1..i*IL_vkt,.]
}

/*HCV*/
for (i=1; i< hcv_types; i++){
	hcv_vkt_hist[1..IL_vkt,(i-1)* VKT_ages_n+1..i*VKT_ages_n] = hcv_vkt_input[(i-1)*IL_vkt+1..i*IL_vkt,.]
	hcv_eff_hist[1..IL_vkt,(i-1)* VKT_ages_n+1..i*VKT_ages_n] = hcv_eff_input[(i-1)*IL_vkt+1..i*IL_vkt,.]
	hcv_ruc_rate_hist [1..IL_vkt,(i-1)* VKT_ages_n+1..i*VKT_ages_n] = hcv_ruc_rate_input[(i-1)*IL_vkt+1..i*IL_vkt,.]
}

/*BUS*/
for (i=1; i< bus_types; i++){
	bus_vkt_hist[1..IL_vkt,(i-1)* VKT_ages_n+1..i*VKT_ages_n] = bus_vkt_input[(i-1)*IL_vkt+1..i*IL_vkt,.]
	bus_eff_hist[1..IL_vkt,(i-1)* VKT_ages_n+1..i*VKT_ages_n] = bus_eff_input[(i-1)*IL_vkt+1..i*IL_vkt,.]
	bus_ruc_rate_hist [1..IL_vkt,(i-1)* VKT_ages_n+1..i*VKT_ages_n] = bus_ruc_rate_input[(i-1)*IL_vkt+1..i*IL_vkt,.]
}


/** PROJECT FUEL EFFICIENCY IMPROVEMENTS*/

/*** 1. LPV*/

/*Initialise projection matrix*/
lpv_eff_proj = (lpv_eff_hist\J(PL_fleet,veh_ages*lpv_types,0))

/*Construct transition matrix*/
lpv_eff_T = J(veh_ages_n,veh_ages_n,0)
lpv_eff_T[2..veh_ages_n,2..veh_ages_n] = I(veh_ages_minus_one)
lpv_eff_T[1,1] = eff_exog_improvement

/*Project efficiency based on transtition matrix*/
for (i=IL_fleet-1;i<=TL_fleet;i++){
    for (j=1;j<=lpv_types;j++){
        lpv_eff_proj[i+1,(j-1)* VKT_ages_n+1..j*VKT_ages_n]=(lpv_eff_T*lpv_eff_proj[i,(j-1)* VKT_ages_n+1..j*VKT_ages_n]')'
    }
}

/*** 2. LCV */

/*Initialise projection matrix*/
lcv_eff_proj = (lcv_eff_hist\J(PL_fleet,veh_ages*lcv_types,0))

/*Construct transition matrix*/
lcv_eff_T = J(veh_ages_n,veh_ages_n,0)
lcv_eff_T[2..veh_ages_n,2..veh_ages_n] = I(veh_ages_minus_one)
lcv_eff_T[1,1] = eff_exog_improvement

/*Project efficiency based on transtition matrix*/
for (i=IL_fleet-1;i<=TL_fleet;i++){
    for (j=1;j<=lcv_types;j++){
        lcv_eff_proj[i+1,(j-1)* VKT_ages_n+1..j*VKT_ages_n]=(lcv_eff_T*lcv_eff_proj[i,(j-1)* VKT_ages_n+1..j*VKT_ages_n]')'
    }
}

/*** 3. MC*/
/*Initialise projection matrix*/
mc_eff_proj = (mc_eff_hist\J(PL_fleet,veh_ages*mc_types,0))

/*Construct transition matrix*/
mc_eff_T = J(veh_ages_n,veh_ages_n,0)
mc_eff_T[2..veh_ages_n,2..veh_ages_n] = I(veh_ages_minus_one)
mc_eff_T[1,1] = eff_exog_improvement

/*Project efficiency based on transtition matrix*/
for (i=IL_fleet-1;i<=TL_fleet;i++){
    for (j=1;j<=mc_types;j++){
        mc_eff_proj[i+1,(j-1)* VKT_ages_n+1..j*VKT_ages_n]=(mc_eff_T*mc_eff_proj[i,(j-1)* VKT_ages_n+1..j*VKT_ages_n]')'
    }
}

/** 4. HCV*/

/*Initialise projection matrix*/
hcv_eff_proj = (hcv_eff_hist\J(PL_fleet,veh_ages*hcv_types,0))

/*Construct transition matrix*/
hcv_eff_T = J(veh_ages_n,veh_ages_n,0)
hcv_eff_T[2..veh_ages_n,2..veh_ages_n] = I(veh_ages_minus_one)
hcv_eff_T[1,1] = eff_exog_improvement

/*Project efficiency based on transtition matrix*/
for (i=IL_fleet-1;i<=TL_fleet;i++){
    for (j=1;j<=hcv_types;j++){
        hcv_eff_proj[i+1,(j-1)* VKT_ages_n+1..j*VKT_ages_n]=(hcv_eff_T*hcv_eff_proj[i,(j-1)* VKT_ages_n+1..j*VKT_ages_n]')'
    }
}

/** 5. BUS*/

/*Initialise projection matrix*/
bus_eff_proj = (bus_eff_hist\J(PL_fleet,veh_ages*bus_types,0))

/*Construct transition matrix*/
bus_eff_T = J(veh_ages_n,veh_ages_n,0)
bus_eff_T[2..veh_ages_n,2..veh_ages_n] = I(veh_ages_minus_one)
bus_eff_T[1,1] = eff_exog_improvement

/*Project efficiency based on transtition matrix*/
for (i=IL_fleet-1;i<=TL_fleet;i++){
    for (j=1;j<=bus_types;j++){
        bus_eff_proj[i+1,(j-1)* VKT_ages_n+1..j*VKT_ages_n]=(bus_eff_T*bus_eff_proj[i,(j-1)* VKT_ages_n+1..j*VKT_ages_n]')'
    }
}


/** PROJECT RUC RATES */
/* Per km (excluding GST)*/

/*** 1. LPV*/

/*Initialise projection matrix and project based on assumed growth*/
lpv_ruc_rate_proj = (lpv_ruc_rate_hist\J(PL_fleet,veh_ages*lpv_types,0))
for (i=IL_fleet-1;i<=TL_fleet;i++){
        lpv_ruc_rate_proj[i+1,.]= lpv_ruc_rate_proj[i,.]:*(1:+lpv_ruc_rate_growth)
}

/*** 2. LCV*/

/*Initialise projection matrix and project based on assumed growth*/
lcv_ruc_rate_proj = (lcv_ruc_rate_hist\J(PL_fleet,veh_ages*lcv_types,0))
for (i=IL_fleet-1;i<=TL_fleet;i++){
        lcv_ruc_rate_proj[i+1,.]= lcv_ruc_rate_proj[i,.]:*(1:+lcv_ruc_rate_growth)
}

/*** 3. HCV*/

/*Initialise projection matrix and project based on assumed growth*/
hcv_ruc_rate_proj = (hcv_ruc_rate_hist\J(PL_fleet,veh_ages*hcv_types,0))
for (i=IL_fleet-1;i<=TL_fleet;i++){
        hcv_ruc_rate_proj[i+1,.]= hcv_ruc_rate_proj[i,.]:*(1:+hcv_ruc_rate_growth)
}

/*** 4. BUS*/

/*Initialise projection matrix and project based on assumed growth*/
bus_ruc_rate_proj = (bus_ruc_rate_hist\J(PL_fleet,veh_ages*bus_types,0))
for (i=IL_fleet-1;i<=TL_fleet;i++){
        bus_ruc_rate_proj[i+1,.]= bus_ruc_rate_proj[i,.]:*(1:+bus_ruc_rate_growth)
}

/** PROJECT COST PER KM AND TAX PER KM*/

/*** 1. LPV*/
/* NB: (i,:,1:5) are petrol, (i,:,6:10) are diesel, and (i,:,11:13) are the alternative fuel vehicles*/

for (i=1;i<=TL_fleet;i++){
	lpv_cost_perk_proj[i,1* VKT_ages_n+1..5*VKT_ages_n] = (lpv_eff_proj[i,1* VKT_ages_n+1..5*VKT_ages_n]:*petrol_pump_price_proj[i+(Time_length-TL_fleet)]):/100
	lpv_cost_perk_proj[i, 5*VKT_ages_n+1..10*VKT_ages_n] = (lpv_eff_proj[i,5*VKT_ages_n+1..10*VKT_ages_n]:*diesel_pump_price_proj[i+(Time_length-TL_fleet)]):/100 + (lpv_ruc_rate_proj[i, 5*VKT_ages_n+1..10*VKT_ages_n]:*(1:+gst_proj[i+(Time_length-TL_fleet)]))
	lpv_cost_perk_proj[i, 10*VKT_ages_n+1..12*VKT_ages_n] = (lpv_eff_proj[i, 10*VKT_ages_n+1..12*VKT_ages_n]:*petrol_pump_price_proj[i+(Time_length-TL_fleet)]):/100
	lpv_cost_perk_proj[i, 12*VKT_ages_n+1..13*VKT_ages_n] = (lpv_eff_proj[i, 12*VKT_ages_n+1..13*VKT_ages_n]:*elec_base_price_proj[i+(Time_length-TL_fleet)]):/100
	lpv_cost_perk_r_proj[i,.] = lpv_cost_perk_proj[i,.]:/cpi_proj[i+8]
	lpv_tax_perk_proj[i,1* VKT_ages_n+1..5*VKT_ages_n] = (lpv_eff_proj[i,1* VKT_ages_n+1..5*VKT_ages_n]:*petrol_taxes_proj[i+(Time_length-TL_fleet)]):/100
	lpv_tax_perk_proj[i, 5*VKT_ages_n+1..10*VKT_ages_n]= ((lpv_eff_proj[i, 5*VKT_ages_n+1..10*VKT_ages_n]:*diesel_taxes_proj[i+(Time_length-TL_fleet)]):/100) + lpv_ruc_rate_proj[i, 5*VKT_ages_n+1..10*VKT_ages_n]
	lpv_tax_perk_proj[i, 10*VKT_ages_n+1..12*VKT_ages_n]= (lpv_eff_proj[i, 10*VKT_ages_n+1..12*VKT_ages_n]:*petrol_taxes_proj[i+(Time_length-TL_fleet)]):/100
	lpv_tax_perk_proj[i, 12*VKT_ages_n+1..13*VKT_ages_n]= ((lpv_eff_proj[i, 12*VKT_ages_n+1..13*VKT_ages_n]:*petrol_taxes_proj[i+(Time_length-TL_fleet)]):/100):*elec_tax
}

/*** 2. LCV*/

for (i=1;i<=TL_fleet;i++){
	lcv_cost_perk_proj[i,1* VKT_ages_n+1..5*VKT_ages_n] = (lcv_eff_proj[i,1* VKT_ages_n+1..5*VKT_ages_n]:*petrol_pump_price_proj[i+(Time_length-TL_fleet)]):/100
	lcv_cost_perk_proj[i, 5*VKT_ages_n+1..10*VKT_ages_n] = (lcv_eff_proj[i,5*VKT_ages_n+1..10*VKT_ages_n]:*diesel_pump_price_proj[i+(Time_length-TL_fleet)]):/100 + (lcv_ruc_rate_proj[i, 5*VKT_ages_n+1..10*VKT_ages_n]:*(1:+gst_proj[i+(Time_length-TL_fleet)]))
	lcv_cost_perk_proj[i, 10*VKT_ages_n+1..12*VKT_ages_n] = (lcv_eff_proj[i, 10*VKT_ages_n+1..12*VKT_ages_n]:*petrol_pump_price_proj[i+(Time_length-TL_fleet)]):/100
	lcv_cost_perk_proj[i, 12*VKT_ages_n+1..13*VKT_ages_n] = (lcv_eff_proj[i, 12*VKT_ages_n+1..13*VKT_ages_n]:*elec_base_price_proj[i+(Time_length-TL_fleet)]):/100
	lcv_cost_perk_r_proj[i,.] = lcv_cost_perk_proj[i,.]:/cpi_proj[i+8]
	lcv_tax_perk_proj[i,1* VKT_ages_n+1..5*VKT_ages_n] = (lcv_eff_proj[i,1* VKT_ages_n+1..5*VKT_ages_n]:*petrol_taxes_proj[i+(Time_length-TL_fleet)]):/100
	lcv_tax_perk_proj[i, 5*VKT_ages_n+1..10*VKT_ages_n]= ((lcv_eff_proj[i, 5*VKT_ages_n+1..10*VKT_ages_n]:*diesel_taxes_proj[i+(Time_length-TL_fleet)]):/100) + lcv_ruc_rate_proj[i, 5*VKT_ages_n+1..10*VKT_ages_n]
	lcv_tax_perk_proj[i, 10*VKT_ages_n+1..12*VKT_ages_n]= (lcv_eff_proj[i, 10*VKT_ages_n+1..12*VKT_ages_n]:*petrol_taxes_proj[i+(Time_length-TL_fleet)]):/100
	lcv_tax_perk_proj[i, 12*VKT_ages_n+1..13*VKT_ages_n]= ((lcv_eff_proj[i, 12*VKT_ages_n+1..13*VKT_ages_n]:*petrol_taxes_proj[i+(Time_length-TL_fleet)]):/100):*elec_tax
}

/*** 3. MC*/
for (i=1; i<=TL_fleet;i++){
mc_cost_perk_proj[i,.] = (mc_eff_proj[i,.]:*petrol_pump_price_proj[i+(Time_length-TL_fleet)]):/100
mc_cost_perk_r_proj[i,.] = mc_cost_perk_proj[i,.]:/cpi_proj[i+(Time_length-TL_fleet)]

mc_tax_perk_proj[i,.] = (mc_eff_proj[i,.]:*petrol_taxes_proj[i+(Time_length-TL_fleet)]):/100
}

/*** 4. HCV - NB that costs here are calculated GST inclusive*/
/* NB: (i,:,1:9) are petrol, (i,:,10:18) are diesel*/

for (i=1; i<=TL_fleet;i++){
hcv_cost_perk_proj[i,1*VKT_ages_n+1..9*VKT_ages_n]= (hcv_eff_proj[i,1* VKT_ages_n+1..9*VKT_ages_n]:*petrol_pump_price_proj[i+(Time_length-TL_fleet)]):/100;
hcv_cost_perk_proj[i,9*VKT_ages_n+1..18*VKT_ages_n]= ((hcv_eff_proj[i,9*VKT_ages_n+1..18*VKT_ages_n]:*diesel_pump_price_proj[i+(Time_length-TL_fleet)]):/100) + (hcv_ruc_rate_proj[i,9*VKT_ages_n+1..18*VKT_ages_n]:*(1+gst_proj[i+(Time_length-TL_fleet)]))
hcv_cost_perk_r_proj[i,.] = hcv_cost_perk_proj[i,.]:/cpi_proj[i+(Time_length-TL_fleet)]
hcv_tax_perk_proj[i,1*VKT_ages_n+1..9*VKT_ages_n]= (hcv_eff_proj[i, 1*VKT_ages_n+1..9*VKT_ages_n]:*petrol_taxes_proj[i+(Time_length-TL_fleet)]):/100
hcv_tax_perk_proj[i,9*VKT_ages_n+1..18*VKT_ages_n]= ((hcv_eff_proj[i,9*VKT_ages_n+1..18*VKT_ages_n]:*diesel_taxes_proj[i+(Time_length-TL_fleet)]):/100) + hcv_ruc_rate_proj[i,9*VKT_ages_n+1..18*VKT_ages_n]
}

/*** 5. BUS*/
/* NB: (i,:,1:3) are petrol, (i,:,4:9) are diesel*/

for (i=1; i<=TL_fleet;i++){
bus_cost_perk_proj[i,1*VKT_ages_n+1..3*VKT_ages_n] = (bus_eff_proj[i,1*VKT_ages_n+1..3*VKT_ages_n]:*petrol_pump_price_proj[i+(Time_length-TL_fleet)]):/100
bus_cost_perk_proj[i,3*VKT_ages_n+1..9*VKT_ages_n] = ((bus_eff_proj[i, 3*VKT_ages_n+1..9*VKT_ages_n]:*diesel_pump_price_proj[i+(Time_length-TL_fleet)]):/100) + (bus_ruc_rate_proj[i, 3*VKT_ages_n+1..9*VKT_ages_n]:*(1:+gst_proj[i+(Time_length-TL_fleet)]))
bus_cost_perk_r_proj[i,.] = bus_cost_perk_proj[i,.]:/cpi_proj[i+(Time_length-TL_fleet)]

bus_tax_perk_proj[i,1*VKT_ages_n+1..3*VKT_ages_n]= (bus_eff_proj[i,1*VKT_ages_n+1..3*VKT_ages_n]:*petrol_taxes_proj[i+(Time_length-TL_fleet)]):/100
bus_tax_perk_proj[i,3*VKT_ages_n+1..9*VKT_ages_n]= ((bus_eff_proj[i,3*VKT_ages_n+1..9*VKT_ages_n]:*diesel_taxes_proj[i+(Time_length-TL_fleet)]):/100) + bus_ruc_rate_proj[i,3*VKT_ages_n+1..9*VKT_ages_n]
}

/** GROWTH IN COST PER VKT PER VEHICLE*/
lpv_cost_perk_r_growth_proj = J(TL_fleet,veh_ages*lpv_types,0)
lcv_cost_perk_r_growth_proj = J(TL_fleet,veh_ages*lcv_types,0)
mc_cost_perk_r_growth_proj = J(TL_fleet,veh_ages*mc_types,0)
hcv_cost_perk_r_growth_proj = J(TL_fleet,veh_ages*hcv_types,0)
bus_cost_perk_r_growth_proj = J(TL_fleet,veh_ages*bus_types,0)

lpv_cost_perk_r_growth_proj[2..TL_fleet,.]= diff(lpv_cost_perk_r_proj):/lpv_cost_perk_r_proj[1..TL_fleet-1,.]
lcv_cost_perk_r_growth_proj[2..TL_fleet,.]= diff(lcv_cost_perk_r_proj):/lcv_cost_perk_r_proj[1..TL_fleet-1,.]
mc_cost_perk_r_growth_proj[2..TL_fleet,.]= diff(mc_cost_perk_r_proj):/mc_cost_perk_r_proj[1..TL_fleet-1,.]
hcv_cost_perk_r_growth_proj[2..TL_fleet,.]= diff(hcv_cost_perk_r_proj):/hcv_cost_perk_r_proj[1..TL_fleet-1,.]
bus_cost_perk_r_growth_proj[2..TL_fleet,.]= diff(bus_cost_perk_r_proj):/bus_cost_perk_r_proj[1..TL_fleet-1,.]

lpv_cost_perk_r_growth_proj=editmissing(lpv_cost_perk_r_growth_proj,0)
lcv_cost_perk_r_growth_proj=editmissing(lcv_cost_perk_r_growth_proj,0)
mc_cost_perk_r_growth_proj=editmissing(mc_cost_perk_r_growth_proj,0)
hcv_cost_perk_r_growth_proj=editmissing(hcv_cost_perk_r_growth_proj,0)
bus_cost_perk_r_growth_proj=editmissing(bus_cost_perk_r_growth_proj,0)

/** (i) Allow for local taxes to be added*/

local_tax = J(Time_length,Regl,0)
local_price_effect = J(Time_length,Regl,0)
/* local_tax_year_introduced = 2014;*/
local_tax_introduced = local_tax_year_introduced-Ts+1
local_tax[local_tax_introduced,.] = intial_local_tax_by_reg
/*lpv_proj comes from vehicle_fleet.do*/
lpv_shares = lpv_proj:/J(1,veh_ages_n*lpv_types,rowsum(lpv_proj))
ave_lpv_cost_perk = (J(Time_length - VKT_time_length-1,1,0)\rowsum(lpv_shares:*lpv_cost_perk_proj))
ave_lpv_cost_perk = J(1,Regl,ave_lpv_cost_perk)
for (i = local_tax_introduced;i<=Time_length-1;i++){
local_tax[i+1,.] = local_tax[i,.]:*(1:+local_tax_rate_of_increase)
}

cost_perk_plus_tax = ave_lpv_cost_perk
cost_perk_plus_tax[2..rows(cost_perk_plus_tax),.] = cost_perk_plus_tax[2..rows(cost_perk_plus_tax),.] + local_tax[2..rows(local_tax),.]

for (i = local_tax_introduced;i<=Time_length-1;i++){
local_price_effect[i+1,.] = 0.5:*(cost_perk_plus_tax[i+1,.]:/ave_lpv_cost_perk[i+1,.]:-1)+1.5:*(cost_perk_plus_tax[i,.]:/ave_lpv_cost_perk[i,.]:-1)+2:*(cost_perk_plus_tax[i-1,.]:/ave_lpv_cost_perk[i-1,.]:-1)+0.5:*(cost_perk_plus_tax[i-2,.]:/ave_lpv_cost_perk[i-2,.]:-1)
}


/** Travel by HH
panel_input_t = length(2004..2020)
panel_backcast = length(1992..2003)
panel_forecast = length(2021..2050)*/
j_t = TL
j_r = 12
j_h = 6
j_n = j_h*j_t*j_r
c = J(j_t*j_r*j_h,1,1)
c_hr = J(j_t*j_r*j_h,j_h*j_r,0)

/*
c_hr = num2cell(c_hr,1)
c_hr = blockdiag(c_hr)*/
c_t = J(j_t*j_r*j_h,TL,0)
c_hr_j = J(TL,1,1)
c_t_j = I(TL)
for (i=1;i<=TL;i++){
	c_hr[(i-1)*TL+1..i*TL,i]=c_hr_j
	c_t[(i-1)*TL+1..i*TL,.]=c_t_j
}
/*Construct input data sets*/
/* NOTE: panel input data is ordered in alphabetical order*/
/* To convert model reg order to alphabetical: 2,4,8,11,6,1,9,10,5,12,3,7*/

/*(a) incomes*/
/*Dimensions of reg_hh_ave_inc (in Growth and income.do) is yr(59)x(hh type(6)xregion(12))*/
reg_hh_ave_inc1 = (reg_hh_ave_inc[.,1*length(HH_str)+1..2*length(HH_str)],reg_hh_ave_inc[.,3*length(HH_str)+1..4*length(HH_str)],reg_hh_ave_inc[.,7*length(HH_str)+1..8*length(HH_str)],reg_hh_ave_inc[.,10*length(HH_str)+1..11*length(HH_str)],reg_hh_ave_inc[.,5*length(HH_str)+1..6*length(HH_str)],reg_hh_ave_inc[.,1..length(HH_str)],reg_hh_ave_inc[.,8*length(HH_str)+1..9*length(HH_str)],reg_hh_ave_inc[.,9*length(HH_str)+1.. 10*length(HH_str)],reg_hh_ave_inc[.,4*length(HH_str)+1..5*length(HH_str)],reg_hh_ave_inc[.,11*length(HH_str)+1..12*length(HH_str)],reg_hh_ave_inc[.,2*length(HH_str)+1..3*length(HH_str)],reg_hh_ave_inc[.,6*length(HH_str)+1.. 7*length(HH_str)])
                
hh_inc_fwd = reg_hh_ave_inc1[2..rows(reg_hh_ave_inc1),.]:/reg_hh_ave_inc1[1..rows(reg_hh_ave_inc1)-1,.]
hh_inc_fwd = (J(8,j_r*j_h,1)\hh_inc_fwd[8..rows(hh_inc_fwd),.])
hh_inc_back = reg_hh_ave_inc[1..rows(reg_hh_ave_inc)-1,.]:/reg_hh_ave_inc[2..rows(reg_hh_ave_inc),.]
hh_inc_back = (J(7,j_r*j_h,1)\hh_inc_back[8..rows(hh_inc_back),.]\J(1,j_r*j_h,1))
inc_hrt1 = colshape(inc_input_hrt,11)'
inc_hrt = (J(panel_backcast,j_r*j_h,0)\reg_hh_ave_inc1[13..29,.]\J(panel_forecast,j_r*j_h,0))
for (i=1;i<=panel_backcast;i++){
    inc_hrt[panel_backcast+1-i,.]=inc_hrt[panel_backcast+2-i,.]:*hh_inc_back[panel_backcast+1-i,.]
}
for (i=panel_backcast+panel_input_t;i<=panel_backcast+panel_input_t+panel_forecast-1;i++){
    inc_hrt[i+1,.]=inc_hrt[i,.]:*hh_inc_fwd[i+1,.]
}
mata drop inc_hrt1 

/*(b)cost_perk */

cost_perk_plus_tax1 = (cost_perk_plus_tax[.,2],cost_perk_plus_tax[.,4],cost_perk_plus_tax[.,8],cost_perk_plus_tax[.,11],cost_perk_plus_tax[.,6],cost_perk_plus_tax[.,1],cost_perk_plus_tax[.,9],cost_perk_plus_tax[.,10],cost_perk_plus_tax[.,5],cost_perk_plus_tax[.,12],cost_perk_plus_tax[.,3],cost_perk_plus_tax[.,7])
cost_for_panel = J(1,6,cost_perk_plus_tax1)
cost_fwd = cost_for_panel[2..TL,.]:/cost_for_panel[1..TL-1,.]
cost_fwd = (J(10,j_r*j_h,1)\cost_fwd[10..rows(cost_fwd),.])
cost_back = cost_for_panel[1..TL-1,.]:/cost_for_panel[2..rows(cost_for_panel),.]
cost_back = (J(9,j_r*j_h,1)\cost_back[10..rows(cost_back),.]\J(1,j_r*j_h,1))
cost_hrt1 = colshape(cost_input_hrt,11)'

/*cost_hrt = [zeros(panel_backcast,j_r,j_h);cost_hrt1;zeros(panel_forecast,j_r,j_h)];*/
cost_hrt = (J(panel_backcast,j_r*j_h,0)\cost_for_panel[13..29,.]\J(panel_forecast,j_r*j_h,0))
for (i=1;i<=panel_backcast+2;i++){
    cost_hrt[panel_backcast+3-i,.]= cost_hrt[panel_backcast+4-i,.]:*cost_back[panel_backcast+3-i,.]
}
for (i=panel_backcast+panel_input_t;i<=panel_backcast+panel_input_t+panel_forecast-1;i++){
    cost_hrt[i+1,.]=cost_hrt[i,.]:*cost_fwd[i+1,.]
}
mata drop cost_hrt1 
cost_inc_hrt = colshape(cost_hrt',1):/colshape(inc_hrt',1)

/*(c)density*/
reg_dens1 = (reg_dens[.,2],reg_dens[.,4],reg_dens[.,8],reg_dens[.,11],reg_dens[.,6],reg_dens[.,1],reg_dens[.,9],reg_dens[.,10],reg_dens[.,5],reg_dens[.,12],reg_dens[.,3],reg_dens[.,7])

dens_for_panel = J(1,6,reg_dens1)
dens_fwd = dens_for_panel[2..TL,.]:/dens_for_panel[1..TL-1,.]
dens_fwd = (J(8,j_r*j_h,1)\dens_fwd[8..rows(dens_fwd),.])
dens_back = dens_for_panel[1..TL-1,.]:/dens_for_panel[2..TL,.]
dens_back = (J(7,j_r*j_h,1)\dens_back[8..rows(dens_back),.]\J(1,j_r*j_h,1))
/*hh_inc_back = reshape(hh_inc_back,j_n,1);*/

dens_hrt1 = colshape(dens_input_hrt,11)'
dens_hrt1 = dens_hrt1\J(6,1,dens_hrt1[11,.])
dens_hrt = (J(panel_backcast,j_r*j_h,0)\dens_hrt1\J(panel_forecast,j_r*j_h,0))
for (i=1;i<=panel_backcast;i++){
    dens_hrt[panel_backcast+1-i,.]= dens_hrt[panel_backcast+2-i,.]:*dens_back[panel_backcast+1-i,.]
}
for (i=panel_backcast+panel_input_t;i<=panel_backcast+panel_input_t+panel_forecast-1;i++){
dens_hrt[i+1,.]=dens_hrt[i,.]:*dens_fwd[i+1,.]:*density_scenario_fwd[i+1,.]
}
dens_hrt_reshape = log(dens_hrt)
dens_hrt = log(colshape(dens_hrt',1))

mata drop dens_hrt1

/* (d) Age*/
/*Define vector of region names*/
reg_names = ("nor", "akl", "wai", "bop", "tar", "man", "wel", "can", "otg", "sth", "gis", "usi")

/*Define matrix of ages*/
ages_hrt1 = (akl_alon_age , bop_alon_age , can_alon_age , gis_alon_age , man_alon_age , nor_alon_age , otg_alon_age , sth_alon_age , tar_alon_age , usi_alon_age , wai_alon_age , wel_alon_age, akl_cple_age , bop_cple_age , can_cple_age , gis_cple_age , man_cple_age , nor_cple_age , otg_cple_age , sth_cple_age , tar_cple_age , usi_cple_age , wai_cple_age , wel_cple_age, akl_mult_age, bop_mult_age, can_mult_age, gis_mult_age, man_mult_age, nor_mult_age, otg_mult_age, sth_mult_age, tar_mult_age, usi_mult_age, wai_mult_age, wel_mult_age, akl_multif_age, bop_multif_age, can_multif_age, gis_multif_age, man_multif_age, nor_multif_age, otg_multif_age, sth_multif_age, tar_multif_age, usi_multif_age, wai_multif_age, wel_multif_age, akl_onep_age, bop_onep_age, can_onep_age, gis_onep_age, man_onep_age, nor_onep_age, otg_onep_age, sth_onep_age, tar_onep_age, usi_onep_age, wai_onep_age, wel_onep_age, akl_twop_age, bop_twop_age, can_twop_age, gis_twop_age, man_twop_age, nor_twop_age, otg_twop_age, sth_twop_age, tar_twop_age, usi_twop_age, wai_twop_age, wel_twop_age)

ages_hrt = log(colshape(ages_hrt1',1))

/*Reshape ages matrix to 3-dimensional array
j_t = 12 /* number of regions*/
j_r = 6 /* number of household types*/
j_h = 106 /* number of ages*/
j_n = j_t*j_r*j_h /* total number of observations*/
			ages_hrt1 = reshape(ages_hrt1, j_t, j_r, j_h)

/*Compute the logarithm of the reshaped ages array*/
		ages_hrt = log(reshape(ages_hrt1, j_n, 1))*/

/* (e) unemployment*/
/*(e) unemployment*/
j_t = TL
j_r = 12
j_h = 6
reg_unemp1 = (reg_unemployment_fcast_rate[.,2], reg_unemployment_fcast_rate[.,4],reg_unemployment_fcast_rate[.,8], reg_unemployment_fcast_rate[.,11],reg_unemployment_fcast_rate[.,6], reg_unemployment_fcast_rate[.,1],reg_unemployment_fcast_rate[.,9], reg_unemployment_fcast_rate[.,10],reg_unemployment_fcast_rate[.,5], reg_unemployment_fcast_rate[.,12],reg_unemployment_fcast_rate[.,3],reg_unemployment_fcast_rate[.,7])
unemp_for_panel = J(1,j_h,reg_unemp1)
unemp_fwd = unemp_for_panel[2..TL,.]:/unemp_for_panel[1..TL-1,.]
/*unemp_fwd = (1, J(rows(unemp_fwd),cols(unemp_fwd),3)) \ (unemp_fwd, J(rows(unemp_fwd),cols(unemp_fwd),3))*/
unemp_fwd = (J(8,j_r*j_h,1)\unemp_fwd[8..rows(unemp_fwd),.])
unemp_hrt1 = colshape(unemp_input_hrt,11)'
unemp_hrt1 = unemp_hrt1\J(6,1,unemp_hrt1[11,.])
unemp_hrt = (J(panel_backcast, j_r*j_h,0)\ unemp_hrt1\ J(panel_forecast, j_r*j_h,0))
/*unemp_fwd = unemp_for_panel[2..TL,.]:/unemp_for_panel[1..TL-1,.]*/
unemp_back = unemp_for_panel[1..TL-1,.]:/unemp_for_panel[2..TL,.]
unemp_back = (J(7,j_r*j_h,1)\unemp_back[8..rows(unemp_back),.]\J(1,j_r*j_h,1))
unemp_hrt = (J(panel_backcast,j_r*j_h,0)\unemp_hrt1\J(panel_forecast,j_r*j_h,0))
for (i=1;i<=panel_backcast;i++){
    unemp_hrt[panel_backcast+1-i,.]= unemp_hrt[panel_backcast+2-i,.]:*unemp_back[panel_backcast+1-i,.]
}
for (i=panel_backcast+panel_input_t;i<=panel_backcast+panel_input_t+panel_forecast-1;i++){
    unemp_hrt[i+1,.]=unemp_hrt[i,.]:*unemp_fwd[i+1,.]
}
unemp_hrt = colshape(unemp_hrt',1)
mata drop unemp_hrt1
/* (f) speed*/
speed1 = colshape(speed_input_hrt,11)'
speed1 = speed1\J(6,1,speed1[11,.])

speed_hrt1 = (J(panel_backcast ,1,speed1[1,.])\speed1\J(panel_forecast,1,speed1[rows(speed1),.]))

for (i=panel_backcast+panel_input_t;i<=panel_backcast+panel_input_t+panel_forecast-1;i++){    
	speed_hrt1[i+1,.]=speed_hrt1[i,.]:*speed_scenario_fwd[i+1,.]
}
speed_hrt = log(colshape(speed_hrt1',1))
mata drop speed_hrt1

/** Fit travel models */
X_j = (cost_inc_hrt, dens_hrt, ages_hrt, unemp_hrt, unemp_hrt:*dens_hrt, speed_hrt, speed_hrt:*dens_hrt)

X_d = (cost_inc_hrt, unemp_hrt, unemp_hrt:*dens_hrt, speed_hrt)

X_j = (c, X_j, c_hr, c_t)

X_d = (c, X_d, c_hr, c_t)

j_hrt = X_j*beta_j

d_hrt = X_d*beta_d

/*need to rearrange order for hh by region - data is in model order and we */
/*need to turn it into alphabetcial order */

/*Note: fix the inconsistency of regional orderings as this is a bad practice. */

alon_reg1 = (alon_reg[.,2],alon_reg[.,4],alon_reg[.,8],alon_reg[.,11],alon_reg[.,6],alon_reg[.,1],alon_reg[.,9],alon_reg[.,10],alon_reg[.,5],alon_reg[.,12],alon_reg[.,3],alon_reg[.,7])
cple_reg1 = (cple_reg[.,2],cple_reg[.,4],cple_reg[.,8],cple_reg[.,11],cple_reg[.,6],cple_reg[.,1],cple_reg[.,9],cple_reg[.,10],cple_reg[.,5],cple_reg[.,12],cple_reg[.,3],cple_reg[.,7])
multi_reg1 = (multi_reg[.,2],multi_reg[.,4],multi_reg[.,8],multi_reg[.,11],multi_reg[.,6],multi_reg[.,1],multi_reg[.,9],multi_reg[.,10],multi_reg[.,5],multi_reg[.,12],multi_reg[.,3],multi_reg[.,7])
multif_reg1 = (multif_reg[.,2],multif_reg[.,4],multif_reg[.,8],multif_reg[.,11],multif_reg[.,6],multif_reg[.,1],multif_reg[.,9],multif_reg[.,10],multif_reg[.,5],multif_reg[.,12],multif_reg[.,3],multif_reg[.,7])
onep_reg1 = (onep_reg[.,2],onep_reg[.,4],onep_reg[.,8],onep_reg[.,11],onep_reg[.,6],onep_reg[.,1],onep_reg[.,9],onep_reg[.,10],onep_reg[.,5],onep_reg[.,12],onep_reg[.,3],onep_reg[.,7])
twop_reg1=(twop_reg[.,2],twop_reg[.,4],twop_reg[.,8],twop_reg[.,11],twop_reg[.,6],twop_reg[.,1],twop_reg[.,9],twop_reg[.,10],twop_reg[.,5],twop_reg[.,12],twop_reg[.,3],twop_reg[.,7])

hh_hrt1 = (alon_reg1,cple_reg1,multi_reg1,multif_reg1,onep_reg1,twop_reg1)

/* Calibrating for the population trend 
hh_hrt1_sum = rowsum(hh_hrt1)
hh_hrt1_shr = hh_hrt1:/hh_hrt1_sum
hh_hrt1_base_cal = hh_hrt1_sum[29]/pop[29]
hh_hrt1_sum_cal = (hh_hrt1_sum[1..29]\(hh_hrt1_base_cal:*pop[30..rows(pop)]))
hh_hrt1_cal = hh_hrt1_shr:*hh_hrt1_sum_cal
*/
/* SCENARIO: Adjust population to MBIE's */
pop_old = pop
hh_hrt1_sum = rowsum(hh_hrt1)
hh_hrt1_shr = hh_hrt1:/hh_hrt1_sum
hh_hrt1_base_cal = pop_mbie2250[1]/hh_hrt1_sum[31]
hh_hrt1_mul = hh_hrt1_base_cal:*hh_hrt1_sum[31..rows(pop)]
hh_hrt1_base_cal_pop = pop[30]/hh_hrt1_sum[30]
hhr_hrt1_mul_pop = hh_hrt1_base_cal_pop:*hh_hrt1_sum[1..30]
hh_hrt1_sum_cal = (hhr_hrt1_mul_pop[1..30]\hh_hrt1_mul)
pop21_smoothing = (pop[29]+pop_mbie2250[1])/2
hh_hrt1_sum_cal = pop[1..29]\pop21_smoothing\pop_mbie2250'
hh_hrt1_cal = hh_hrt1_shr:*hh_hrt1_sum_cal
hh_hrt1_nocal = hh_hrt1
hh_hrt1 = hh_hrt1_cal

/*hh_hrt = colshape(hh_hrt1',1)*/
hh_hrt = colshape(hh_hrt1',1)

mata drop hh_hrt1


/*NOTE regions are still in alphabetical order here */
journeys_hrt = exp(j_hrt):*hh_hrt
distance_hrt = exp(d_hrt):*journeys_hrt

distance_rt=J(TL,12*6,0)
journeys_rt=J(TL,12*6,0)

distance_rt = rowshape(distance_hrt',72)'
journeys_rt = rowshape(journeys_hrt',72)'


/*

for (i = 1; i<=12; i++) { 
	for (j=1; j<=6; j++){
	distance_rt[.,(i-1)*6+j] = distance_hrt[(i-1)*6*12+(j-1)*TL+1..(i-1)*6*12+j*TL]
	journeys_rt[.,(i-1)*6+j] = journeys_hrt[(i-1)*6*12+(j-1)*TL+1..(i-1)*6*12+j*TL]
	}
}
*/

distance_t = rowsum(distance_rt)
journeys_t = rowsum(journeys_rt)

/** Run mode choice model*/
end
do "mode_choice.do"
mata
/** PROJECT VKT PER VEHICLE*/
/* Per vehicle values left as per NLTDM for reference*/
/* VKT growth presumed to track modes of travel*/
/* Specifically */
bus_dist_g = bus_dist_t[2..rows(bus_dist_t)]:/bus_dist_t[1..rows(bus_dist_t)-1] 
drive_dist_g = drive_dist_t[2..rows(drive_dist_t)]:/drive_dist_t[1..rows(drive_dist_t)-1]
hcv_dist_g = roadfreight_tkm_fcast[2..rows(roadfreight_tkm_fcast)]:/roadfreight_tkm_fcast[1..rows(roadfreight_tkm_fcast)-1]
/*For fleet level growth */
bus_dist_g4fleet = J(1,VKT_ages_n*bus_types,bus_dist_g[TL_fiscal-PL_fleet..rows(bus_dist_g)])
drive_dist_g4fleet = J(1,VKT_ages_n*lpv_types,drive_dist_g[TL_fiscal-PL_fleet..rows(drive_dist_g)])
hcv_dist_g4fleet = J(1,VKT_ages_n*hcv_types,hcv_dist_g[TL_fiscal-PL_fleet..rows(hcv_dist_g)])


/*This adjustment below is necessary so that lcv vkt for alternative fuel*/
/*vehciles will grow*/
lcv_proj[1..IL_fleet,11*VKT_ages_n+1..13*VKT_ages_n] = J(IL_fleet,2*VKT_ages_n,1)

lpv_tot_g = rowsum(lpv_proj[2..rows(lpv_proj),.]):/rowsum(lpv_proj[1..rows(lpv_proj)-1,.])
lcv_tot_g = rowsum(lcv_proj[2..rows(lcv_proj),.]):/rowsum(lcv_proj[1..rows(lpv_proj)-1,.])
/*** 1. LPV*/
/* Give alternate fuel cars the starting average VKT per vehicle in the last*/
/* year of the history - ensuring as much as we can that */
/* vkt is evenly taken from other types and given to the alternative fuel*/
/* vehicles*/

/*Adding a vkt per veh growth rate  */
drive_dist_g4fleet_lpv = drive_dist_g4fleet:/J(1,VKT_ages_n*lpv_types,lpv_tot_g[rows(lpv_tot_g)-PL_fleet+1..rows(lpv_tot_g)])  


/* Average vkt per vehicle and by age in the history*/
ave_in_hist = rowsum(lpv_vkt_hist[rows(lpv_vkt_hist),.]:*lpv[rows(lpv),.]):/rowsum(lpv[rows(lpv),.])
ave_by_age_in_hist=colsum(lpv_vkt_hist[rows(lpv_vkt_hist),(12)* VKT_ages_n+1..13*VKT_ages_n]:*lpv[rows(lpv),(12)* VKT_ages_n+1..13*VKT_ages_n]):/colsum(lpv[IL_vkt,(12)* VKT_ages_n+1..13*VKT_ages_n])

/* Add the average by age to the history */
lpv_vkt_hist[rows(lpv_vkt_hist),10*VKT_ages_n+1..13*VKT_ages_n] = J(1,3,ave_by_age_in_hist) 
lpv_vkt_perv_proj = (lpv_vkt_hist\J(PL_fleet-1,VKT_ages_n*lpv_types,0))

lpv_vkt_proj = lpv_vkt_perv_proj:*lpv_proj[2..rows(lpv_proj),.]

/*Growth in vehicle types*/
lpv_proj_g = lpv_proj[2..rows(lpv_proj),.]:/lpv_proj[1..rows(lpv_proj)-1,.]
lpv_proj_g = editmissing(lpv_proj_g,0)
lpv_proj_g_for_vkt = lpv_proj_g[rows(lpv_proj_g)-PL_fleet+1..rows(lpv_proj_g),.]




for (i = 1;i<=PL_fleet-1;i++){
lpv_vkt_proj[IL_vkt+i,.] = (drive_dist_g4fleet_lpv[i,.]:*lpv_proj_g_for_vkt[i,.]):*lpv_vkt_proj[IL_vkt+i-1,.]
}


/*** 2. LCV*/
/* Give alternate fuel cars the starting average VKT per vehicle in the last*/
/* year of the history - ensuring as much as we can that */
/* vkt is evenly taken from other types and given to the alternative fuel*/
/* vehicles*/

/*Adding a vkt per veh growth rate */
drive_dist_g4fleet_lcv = drive_dist_g4fleet:/J(1,VKT_ages_n*lcv_types,lcv_tot_g[rows(lcv_tot_g)-PL_fleet+1..rows(lpv_tot_g)])

/* Average vkt per vehicle and by age in the history*/
ave_in_hist_lcv = rowsum(lcv_vkt_hist[rows(lcv_vkt_hist),.]:*lcv[rows(lcv),.]):/rowsum(lcv[rows(lcv),.])
ave_by_age_in_hist_lcv = colsum(lcv_vkt_hist[rows(lcv_vkt_hist),(12)* VKT_ages_n+1..13*VKT_ages_n]:*lcv[rows(lpv),(12)* VKT_ages_n+1..13*VKT_ages_n]):/colsum(lcv[IL_vkt,(12)* VKT_ages_n+1..13*VKT_ages_n])

/* Add the average by age to the history */
lcv_vkt_hist[rows(lcv_vkt_hist),10*VKT_ages_n+1..13*VKT_ages_n] = J(1,3,ave_by_age_in_hist_lcv)
lcv_vkt_perv_proj = (lcv_vkt_hist\J(PL_fleet-1,VKT_ages_n*lcv_types,0))
lcv_vkt_proj = lcv_vkt_perv_proj:*lcv_proj[2..rows(lcv_proj),.]

/*Growth in vehicle types*/
lcv_proj_g = lcv_proj[2..rows(lcv_proj),.]:/lcv_proj[1..rows(lcv_proj)-1,.]
lcv_proj_g = editmissing(lcv_proj_g,0)
lcv_proj_g_for_vkt = lcv_proj_g[rows(lcv_proj_g)-PL_fleet+1..rows(lcv_proj_g),.]
for (i = 1;i<=PL_fleet-1;i++){
lcv_vkt_proj[IL_vkt+i,.] = (drive_dist_g4fleet_lcv[i,.]:*lcv_proj_g_for_vkt[i,.]):*lcv_vkt_proj[IL_vkt+i-1,.]
}

/*** 3. MC*/
mc_vkt_perv_proj = (mc_vkt_hist\J(PL_fleet-1,VKT_ages_n*mc_types,0))

for (i = IL_vkt;i<=TL_vkt-1;i++){
mc_vkt_perv_proj[i,.] = mc_vkt_perv_proj[i-1,.]:*(1:+(mc_vkt_cost_elasticity:*mc_cost_perk_r_growth_proj[i+1,.])):+(mc_vkt_income_elasticity:*nz_hh_inc_growth[i+(Time_length-TL_fleet)])
}

mc_vkt_perv_proj = editmissing(mc_vkt_perv_proj,0)
mc_vkt_proj = mc_vkt_perv_proj:*mc_proj[2..rows(mc_proj),.]



/*** 4. HCV*/
hcv_vkt_perv_proj = (hcv_vkt_hist\J(PL_fleet-1,VKT_ages_n*hcv_types,0))

for (i = IL_vkt;i<=TL_vkt-1;i++){
hcv_vkt_perv_proj[i,.] = hcv_vkt_perv_proj[i-1,.]:*(1:+(hcv_vkt_cost_elasticity:*hcv_cost_perk_r_growth_proj[i+1,.])):+(hcv_vkt_income_elasticity:*nz_hh_inc_growth[i+(Time_length-TL_fleet)])
}

hcv_vkt_perv_proj = editmissing(hcv_vkt_perv_proj,0)
hcv_vkt_proj = hcv_vkt_perv_proj:*hcv_proj[2..rows(hcv_proj),.]

for (i = 1;i<=PL_fleet-1;i++){
hcv_vkt_proj[IL_vkt+i,.] = hcv_dist_g4fleet[i,.]:*hcv_vkt_proj[IL_vkt+i-1,.]
}


/*** 5. BUS*/
bus_vkt_perv_proj = (bus_vkt_hist\J(PL_fleet-1,VKT_ages_n*bus_types,0))

for (i = IL_vkt;i<=TL_vkt-1;i++){
bus_vkt_perv_proj[i,.] = bus_vkt_perv_proj[i-1,.]:*(1:+(bus_vkt_cost_elasticity:*bus_cost_perk_r_growth_proj[i+1,.])):+(bus_vkt_income_elasticity:*gdp_percapita_growth[i+(Time_length-TL_fleet)])
}

bus_vkt_perv_proj = editmissing(bus_vkt_perv_proj,0)
bus_vkt_proj = bus_vkt_perv_proj:*bus_proj[2..rows(bus_proj),.]

for (i = 1;i<=PL_fleet-1;i++){
bus_vkt_proj[IL_vkt+i,.] = bus_dist_g4fleet[i,.]:*bus_vkt_proj[IL_vkt+i-1,.]
}

/** PROJECT TAX REVENUE BY VEHICLE TYPE*/

/*By vehicle type*/
lpv_tax_proj = lpv_tax_perk_proj[2..rows(lpv_tax_perk_proj),.]:*lpv_vkt_proj
lcv_tax_proj = lcv_tax_perk_proj[2..rows(lcv_tax_perk_proj),.]:*lcv_vkt_proj
mc_tax_proj = mc_tax_perk_proj[2..rows(mc_tax_perk_proj),.]:*mc_vkt_proj
hcv_tax_proj = hcv_tax_perk_proj[2..rows(hcv_tax_perk_proj),.]:*hcv_vkt_proj
bus_tax_proj = bus_tax_perk_proj[2..rows(bus_tax_perk_proj),.]:*bus_vkt_proj

lpv_tax_tot = rowsum(lpv_tax_proj)
lcv_tax_tot = rowsum(lcv_tax_proj)
mc_tax_tot = rowsum(mc_tax_proj)
hcv_tax_tot = rowsum(hcv_tax_proj)
bus_tax_tot = rowsum(bus_tax_proj)

lite_ruc = rowsum(lpv_tax_proj[.,5*VKT_ages_n+1..10*VKT_ages_n])+rowsum(lcv_tax_proj[.,5*VKT_ages_n+1..10*VKT_ages_n])
heavy_ruc = rowsum(hcv_tax_proj[.,9*VKT_ages_n+1..18*VKT_ages_n])+rowsum(bus_tax_proj[.,3*VKT_ages_n+1..9*VKT_ages_n])
ruc_proj = lite_ruc + heavy_ruc
fed_proj = ((lpv_tax_tot+lcv_tax_tot):-lite_ruc)+mc_tax_tot+((hcv_tax_tot+bus_tax_tot):-heavy_ruc)

/*Value below is for adjustment in the HH travel module - excludes MC cause*/
/*that is assumed to price insensitive so no adjustment required*/
lite_fed = lpv_tax_tot+lcv_tax_tot-lite_ruc
lite_fed_shr = lite_fed:/(lite_fed+lite_ruc)
lite_ruc_shr = lite_ruc:/ruc_proj
lite_diesel_vkt = rowsum(lpv_vkt_proj[.,5*VKT_ages_n+1..1*VKT_ages_n])+rowsum(lcv_vkt_proj[.,5*VKT_ages_n+1..10*VKT_ages_n])
lite_petrol_vkt = rowsum(lpv_vkt_proj[.,1..5*VKT_ages_n])+rowsum(lcv_vkt_proj[.,1..5*VKT_ages_n])
lite_fed_vkt = rowsum(lpv_vkt_proj[.,1..5*VKT_ages_n])+rowsum(lcv_vkt_proj[.,1..5*VKT_ages_n])+rowsum(lpv_vkt_proj[.,10..13*VKT_ages_n])+rowsum(lcv_vkt_proj[.,10..13*VKT_ages_n])

/* Calculate growth rates*/
licen_growth = diff(fleet_proj_tot):/fleet_proj_tot[1..rows(fleet_proj_tot)-1]
rego_growth = diff(reg_proj_tot):/reg_proj_tot[1..rows(reg_proj_tot)-1]

ruc_growth = (J(Time_length - TL_fleet+1,1,0)\(diff(ruc_proj):/ruc_proj[1..rows(ruc_proj)-1]))
fed_growth = (J(Time_length - TL_fleet+1,1,0)\(diff(fed_proj):/fed_proj[1..rows(fed_proj)-1]))


for (i = IL_fiscal+1;i<=TL_fiscal;i++){
licen[i] = licen[i-1]:*(1+licen_growth[i-1])
ruc[i] = ruc[i-1]:*(1+ruc_growth[i-1])
fed[i] = fed[i-1]:*(1+fed_growth[i-1])
rego[i] = rego[i-1]:*(1+rego_growth[i-1])
}

nltf_proj = licen + ruc + rego + fed
nltf_growth = diff(nltf_proj):/nltf_proj[1..rows(nltf_proj)-1]

for (i = IL_fiscal+1;i<=TL_fiscal;i++){
nltf[i] = nltf[i-1]:*(1+nltf_growth[i-1])
}

mvr = licen+rego

nltf_resid  = nltf - (mvr+fed+ruc)
nltf_components = (fed,ruc,mvr,nltf_resid)

/*values below are millions*/
ruc_per_lite_km = (J(Time_length - TL_fleet+1,1,0)\(lite_ruc_shr:*ruc[(Time_length - TL_fleet)+2..rows(ruc)]:/lite_diesel_vkt))
fed_per_lite_km = (J(Time_length - TL_fleet+1,1,0)\(lite_fed_shr:*fed[(Time_length - TL_fleet)+2..rows(fed)]:/lite_petrol_vkt))

swing_ruc = (J(Time_length - TL_fleet+1,1,0)\(lite_ruc_shr:*ruc[(Time_length - TL_fleet)+2..rows(ruc)]))
swing_fed = (J(Time_length - TL_fleet+1,1,0)\(lite_fed_shr:*fed[(Time_length - TL_fleet)+2..rows(fed)]))

fixed_ruc = ruc - swing_ruc
fixed_fed = fed - swing_fed


/** VKT TOTALS AND AVERAGES*/
lpv_vkt_by_type = J(rows(lpv_vkt_proj),lpv_types,0)
lcv_vkt_by_type = J(rows(lcv_vkt_proj),lpv_types,0)
lpv_vkt_by_age = J(rows(lpv_vkt_proj),VKT_ages_n,0)
lcv_vkt_by_age = J(rows(lcv_vkt_proj),VKT_ages_n,0)

for (i=1; i< lpv_types; i++){
lpv_vkt_by_type[.,i] = rowsum(lpv_vkt_proj[.,(i-1)*VKT_ages_n+1..i*VKT_ages_n])
lcv_vkt_by_type[.,i] = rowsum(lcv_vkt_proj[.,(i-1)*VKT_ages_n+1..i*VKT_ages_n])
}

for (i=1; i< VKT_ages_n; i++){
for (j=1; j< lpv_types; j++){
lpv_vkt_by_age[.,i] = lpv_vkt_by_age[.,i]+lpv_vkt_proj[.,(j-1)*VKT_ages_n+i]
lcv_vkt_by_age[.,i] = lcv_vkt_by_age[.,i]+lcv_vkt_proj[.,(j-1)*VKT_ages_n+i]
}
}

lpv_vkt_total = rowsum(lpv_vkt_proj)
lcv_vkt_total = rowsum(lcv_vkt_proj)
mc_vkt_total = rowsum(mc_vkt_proj)
hcv_vkt_total = rowsum(hcv_vkt_proj)
bus_vkt_total = rowsum(bus_vkt_proj)

lite_vkt_proj_by_age = lcv_vkt_by_age + lpv_vkt_by_age
lite_vkt_proj_total = lcv_vkt_total + lpv_vkt_total

lite_ave_vkt_per_veh = lite_vkt_proj_total:/(lpv_proj_total[2..rows(lpv_proj_total)]+lcv_proj_total[2..rows(lcv_proj_total)])

/** FUEL CONSUMPTION and EMISSIONS*/
/* Calculates fuel consumption (index) and emissions (index) as *indices* i.e. because we use technical efficiencies and*/
/* ignore driver behaviour. To the extent that we assume no major increase*/
/* in congestion or in travel behaviour the indices produced will*/
/* approximate emissions and fuel consumption increases.*/

/*** (i) Fuel consumption*/

lpv_fuel_consumption = lpv_vkt_proj:*lpv_eff_proj[3..rows(lpv_eff_proj),.]
lcv_fuel_consumption = lcv_vkt_proj:*lcv_eff_proj[3..rows(lcv_eff_proj),.]
mc_fuel_consumption = mc_vkt_proj:*mc_eff_proj[3..rows(mc_eff_proj),.]
hcv_fuel_consumption = hcv_vkt_proj:*hcv_eff_proj[3..rows(hcv_eff_proj),.]
bus_fuel_consumption = bus_vkt_proj:*bus_eff_proj[3..rows(bus_eff_proj),.]
mc_petrol_consumption = mc_fuel_consumption


lpv_petrol_consumption = (lpv_vkt_proj[.,1..5*VKT_ages_n]:*lpv_eff_proj[3..rows(lpv_eff_proj), 1..5*VKT_ages_n],lpv_vkt_proj[.,10*VKT_ages_n+1..13*VKT_ages_n]:*lpv_eff_proj[3..rows(lpv_eff_proj),10*VKT_ages_n+1..13*VKT_ages_n])
lcv_petrol_consumption = (lcv_vkt_proj[.,1..5*VKT_ages_n]:*lcv_eff_proj[3..rows(lcv_eff_proj), 1..5*VKT_ages_n],lcv_vkt_proj[.,10*VKT_ages_n+1..13*VKT_ages_n]:*lcv_eff_proj[3..rows(lcv_eff_proj),10*VKT_ages_n+1..13*VKT_ages_n])

hcv_petrol_consumption = hcv_vkt_proj[.,1..9*VKT_ages_n]:*hcv_eff_proj[3..rows(hcv_eff_proj),1..9*VKT_ages_n]
bus_petrol_consumption = bus_vkt_proj[.,1..3*VKT_ages_n]:*bus_eff_proj[3..rows(bus_eff_proj),1..3*VKT_ages_n]

lpv_diesel_consumption = lpv_vkt_proj[.,5*VKT_ages_n+1..10*VKT_ages_n]:*lpv_eff_proj[3..rows(lpv_eff_proj),5*VKT_ages_n+1..10*VKT_ages_n]
lcv_diesel_consumption = lcv_vkt_proj[.,5*VKT_ages_n+1..10*VKT_ages_n]:*lcv_eff_proj[3..rows(lcv_eff_proj),5*VKT_ages_n+1..10*VKT_ages_n]

hcv_diesel_consumption = hcv_vkt_proj[.,9*VKT_ages_n+1..18*VKT_ages_n]:*hcv_eff_proj[3..rows(hcv_eff_proj),9*VKT_ages_n+1..18*VKT_ages_n]

bus_diesel_consumption = bus_vkt_proj[.,3*VKT_ages_n+1..6*VKT_ages_n]:*bus_eff_proj[3..rows(hcv_eff_proj),3*VKT_ages_n+1..6*VKT_ages_n]

lpv_petrol_consumption_tot = rowsum(lpv_petrol_consumption)
lcv_petrol_consumption_tot = rowsum(lcv_petrol_consumption)
mc_petrol_consumption_tot = rowsum(mc_petrol_consumption)
hcv_petrol_consumption_tot = rowsum(hcv_petrol_consumption)
bus_petrol_consumption_tot = rowsum(bus_petrol_consumption)

lpv_diesel_consumption_tot = rowsum(lpv_diesel_consumption)
lcv_diesel_consumption_tot = rowsum(lcv_diesel_consumption)
hcv_diesel_consumption_tot = rowsum(hcv_diesel_consumption)
bus_diesel_consumption_tot = rowsum(bus_diesel_consumption)

petrol_consumption_tot = lpv_petrol_consumption_tot + lcv_petrol_consumption_tot + mc_petrol_consumption_tot + hcv_petrol_consumption_tot + bus_petrol_consumption_tot
diesel_consumption_tot = lpv_diesel_consumption_tot + lcv_diesel_consumption_tot + hcv_diesel_consumption_tot + bus_diesel_consumption_tot

lite_average_fuel_efficiency = (lpv_diesel_consumption_tot + lpv_petrol_consumption_tot + lcv_diesel_consumption_tot + lcv_diesel_consumption_tot):/lite_vkt_proj_total

/*** (ii) ETS costs*/
/* Note: we changed the IL_vkt-2..end dimension of the petrol_ets_cost_proj from original and replaced with 10*/
ets_cost_tot = ((petrol_consumption_tot:*petrol_ets_cost_proj[10..rows(petrol_ets_cost_proj)])+(diesel_consumption_tot:*diesel_ets_cost_proj[10..rows(diesel_ets_cost_proj)])):/100
ets_cost_tot_r = ets_cost_tot:/cpi_proj[10..rows(cpi_proj)]

/*** (iii) Age and type specific emissions*/

/*Age and type specific CO2 emissions*/
lpv_co2 = (lpv_fuel_consumption[.,1..5*VKT_ages_n]:*petrol_co2_factor,lpv_fuel_consumption[.,5*VKT_ages_n+1..10*VKT_ages_n]:*diesel_co2_factor,lpv_fuel_consumption[.,10*VKT_ages_n..13*VKT_ages_n]:*petrol_co2_factor)
lcv_co2 = (lcv_fuel_consumption[.,1..5*VKT_ages_n]:*petrol_co2_factor,lcv_fuel_consumption[.,5*VKT_ages_n+1..10*VKT_ages_n]:*diesel_co2_factor,lcv_fuel_consumption[.,10*VKT_ages_n..13*VKT_ages_n]:*petrol_co2_factor)
mc_co2 = mc_fuel_consumption:*petrol_co2_factor
hcv_co2 = (hcv_fuel_consumption[.,1..9*VKT_ages_n]:*petrol_co2_factor,hcv_fuel_consumption[.,9*VKT_ages_n+1..18*VKT_ages_n]:*diesel_co2_factor)
bus_co2 = (bus_fuel_consumption[.,1..3*VKT_ages_n]:*petrol_co2_factor,bus_fuel_consumption[.,3*VKT_ages_n+1..6*VKT_ages_n]:*diesel_co2_factor,bus_fuel_consumption[.,5*VKT_ages_n+1..9*VKT_ages_n]:*petrol_co2_factor)


/*Age and type specific CH4 emissions*/
lpv_ch4 = (lpv_fuel_consumption[.,1..5*VKT_ages_n]:*petrol_ch4_factor,lpv_fuel_consumption[.,5*VKT_ages_n+1..10*VKT_ages_n]:*diesel_ch4_factor,lpv_fuel_consumption[.,10*VKT_ages_n+1..13*VKT_ages_n]:*petrol_ch4_factor)
lcv_ch4 = (lcv_fuel_consumption[.,1..5*VKT_ages_n]:*petrol_ch4_factor,lcv_fuel_consumption[.,5*VKT_ages_n+1..10*VKT_ages_n]:*diesel_ch4_factor,lcv_fuel_consumption[.,10*VKT_ages_n+1..13*VKT_ages_n]:*petrol_ch4_factor)
mc_ch4 = mc_fuel_consumption:*petrol_ch4_factor
hcv_ch4 = (hcv_fuel_consumption[.,1..9*VKT_ages_n]:*petrol_ch4_factor,hcv_fuel_consumption[.,9*VKT_ages_n+1..18*VKT_ages_n]):*diesel_ch4_factor
bus_ch4 = (bus_fuel_consumption[.,1..3*VKT_ages_n]:*petrol_ch4_factor,bus_fuel_consumption[.,3*VKT_ages_n+1..6*VKT_ages_n]:*diesel_ch4_factor,bus_fuel_consumption[.,6*VKT_ages_n+1..9*VKT_ages_n]:*petrol_ch4_factor)

/*Age and type specific N2O emissions*/
lpv_n2o = (lpv_fuel_consumption[.,1..5*VKT_ages_n]:*petrol_n2o_factor,lpv_fuel_consumption[.,5*VKT_ages_n+1..10*VKT_ages_n]:*diesel_n2o_factor,lpv_fuel_consumption[.,10*VKT_ages_n+1..13*VKT_ages_n]:*petrol_n2o_factor)
lcv_n2o = (lcv_fuel_consumption[.,1..5*VKT_ages_n]:*petrol_n2o_factor,lcv_fuel_consumption[.,5*VKT_ages_n+1..10*VKT_ages_n]:*diesel_n2o_factor,lcv_fuel_consumption[.,10*VKT_ages_n+1..13*VKT_ages_n]:*petrol_n2o_factor)
mc_n2o = mc_fuel_consumption:*petrol_n2o_factor
hcv_n2o = (hcv_fuel_consumption[.,1..9*VKT_ages_n]:*petrol_n2o_factor,hcv_fuel_consumption[.,9*VKT_ages_n+1..18*VKT_ages_n]:*diesel_n2o_factor)
bus_n2o = (bus_fuel_consumption[.,1..3*VKT_ages_n]:*petrol_n2o_factor,bus_fuel_consumption[.,3*VKT_ages_n+1..6*VKT_ages_n]:*diesel_n2o_factor,bus_fuel_consumption[.,6*VKT_ages_n+2..9*VKT_ages_n]:*petrol_n2o_factor)

/*Age and type specific CO emissions*/
lpv_co = (lpv_fuel_consumption[.,1..5*VKT_ages_n]:*petrol_co_factor,lpv_fuel_consumption[.,5*VKT_ages_n+1..10*VKT_ages_n]:*diesel_co_factor,lpv_fuel_consumption[.,10*VKT_ages_n+1..13*VKT_ages_n]:*petrol_co_factor)
lcv_co = (lcv_fuel_consumption[.,1..5*VKT_ages_n]:*petrol_co_factor,lcv_fuel_consumption[.,5*VKT_ages_n+1..10*VKT_ages_n]:*diesel_co_factor,lcv_fuel_consumption[.,10*VKT_ages_n+1..13*VKT_ages_n]:*petrol_co_factor)
mc_co = mc_fuel_consumption:*petrol_co_factor
hcv_co = (hcv_fuel_consumption[.,1..9*VKT_ages_n]:*petrol_co_factor,hcv_fuel_consumption[.,9*VKT_ages_n..18*VKT_ages_n]:*diesel_co_factor)
bus_co = (bus_fuel_consumption[.,1..3*VKT_ages_n]:*petrol_co_factor,bus_fuel_consumption[.,3*VKT_ages_n+1..6*VKT_ages_n]:*diesel_co_factor,bus_fuel_consumption[.,6*VKT_ages_n+1..9*VKT_ages_n]:*petrol_co_factor)

/*Age and type specific NOx emissions*/
lpv_nox = (lpv_fuel_consumption[.,1..5*VKT_ages_n]:*petrol_nox_factor,lpv_fuel_consumption[.,5*VKT_ages_n+1..10*VKT_ages_n]:*diesel_nox_factor,lpv_fuel_consumption[.,10*VKT_ages_n+1..13*VKT_ages_n]:*petrol_nox_factor)
lcv_nox = (lcv_fuel_consumption[.,1..5*VKT_ages_n]:*petrol_nox_factor,lcv_fuel_consumption[.,5*VKT_ages_n+1..10*VKT_ages_n]:*diesel_nox_factor,lcv_fuel_consumption[.,10*VKT_ages_n+1..13*VKT_ages_n]:*petrol_nox_factor)
mc_nox = mc_fuel_consumption:*petrol_nox_factor
hcv_nox = (hcv_fuel_consumption[.,1..9*VKT_ages_n]:*petrol_nox_factor,hcv_fuel_consumption[.,9*VKT_ages_n+1..18*VKT_ages_n]:*diesel_nox_factor)
bus_nox = (bus_fuel_consumption[.,1..3*VKT_ages_n]:*petrol_nox_factor,bus_fuel_consumption[.,3*VKT_ages_n+1..6*VKT_ages_n]:*diesel_nox_factor,bus_fuel_consumption[.,6*VKT_ages_n+1..9*VKT_ages_n]:*petrol_nox_factor)

/*Age and type specific NMVOC emissions*/
lpv_nmvoc = (lpv_fuel_consumption[.,1..5*VKT_ages_n]:*petrol_nmvoc_factor,lpv_fuel_consumption[.,5*VKT_ages_n+1..10*VKT_ages_n]:*diesel_nmvoc_factor,lpv_fuel_consumption[.,10*VKT_ages_n+1..13*VKT_ages_n]:*petrol_nmvoc_factor)
lcv_nmvoc = (lcv_fuel_consumption[.,1..5*VKT_ages_n]:*petrol_nmvoc_factor,lcv_fuel_consumption[.,5*VKT_ages_n+1..10*VKT_ages_n]:*diesel_nmvoc_factor,lcv_fuel_consumption[.,10*VKT_ages_n+1..13*VKT_ages_n]:*petrol_nmvoc_factor)
mc_nmvoc = mc_fuel_consumption:*petrol_nmvoc_factor
hcv_nmvoc = (hcv_fuel_consumption[.,1..9*VKT_ages_n]:*petrol_nmvoc_factor,hcv_fuel_consumption[.,9*VKT_ages_n+1..18*VKT_ages_n]:*diesel_nmvoc_factor)
bus_nmvoc = (bus_fuel_consumption[.,1..3*VKT_ages_n]:*petrol_nmvoc_factor,bus_fuel_consumption[.,3*VKT_ages_n+1..6*VKT_ages_n]:*diesel_nmvoc_factor,bus_fuel_consumption[.,6*VKT_ages_n+1..9*VKT_ages_n]:*petrol_nmvoc_factor)

/*Age and type specific SO2 emissions*/
lpv_so2 = (lpv_fuel_consumption[.,1..5*VKT_ages_n]:*petrol_so2_factor,lpv_fuel_consumption[.,5*VKT_ages_n+1..10*VKT_ages_n]:*diesel_so2_factor,lpv_fuel_consumption[.,10*VKT_ages_n+1..13*VKT_ages_n]:*petrol_so2_factor)
lcv_so2 = (lcv_fuel_consumption[.,1..5*VKT_ages_n]:*petrol_so2_factor,lcv_fuel_consumption[.,5*VKT_ages_n+1..10*VKT_ages_n]:*diesel_so2_factor,lcv_fuel_consumption[.,10*VKT_ages_n+1..13*VKT_ages_n]:*petrol_so2_factor)
mc_so2 = mc_fuel_consumption:*petrol_so2_factor
hcv_so2 = (hcv_fuel_consumption[.,1..9*VKT_ages_n]:*petrol_so2_factor,hcv_fuel_consumption[.,9*VKT_ages_n+1..18*VKT_ages_n]:*diesel_so2_factor)
bus_so2 = (bus_fuel_consumption[.,1..3*VKT_ages_n]:*petrol_so2_factor,bus_fuel_consumption[.,3*VKT_ages_n+1..6*VKT_ages_n]:*diesel_so2_factor,bus_fuel_consumption[.,6*VKT_ages_n+1..9*VKT_ages_n]:*petrol_so2_factor)

/*** (iv) Emissions aggregates*/
/*CO2*/
lpv_co2_tot= rowsum(lpv_co2)
lcv_co2_tot= rowsum(lcv_co2)
mc_co2_tot= rowsum(mc_co2)
hcv_co2_tot= rowsum(hcv_co2)
bus_co2_tot= rowsum(bus_co2)
co2_total = lpv_co2_tot + lcv_co2_tot + mc_co2_tot + hcv_co2_tot + bus_co2_tot


/*CH4*/
lpv_ch4_tot= rowsum(lpv_ch4)
lcv_ch4_tot= rowsum(lcv_ch4)
mc_ch4_tot= rowsum(mc_ch4)
hcv_ch4_tot= rowsum(hcv_ch4)
bus_ch4_tot= rowsum(bus_ch4)
ch4_total = lpv_ch4_tot + lcv_ch4_tot + mc_ch4_tot + hcv_ch4_tot + bus_ch4_tot

/*N2O*/
lpv_n2o_tot= rowsum(lpv_n2o)
lcv_n2o_tot= rowsum(lcv_n2o)
mc_n2o_tot= rowsum(mc_n2o)
hcv_n2o_tot= rowsum(hcv_n2o)
bus_n2o_tot= rowsum(bus_n2o)
n2o_total = lpv_n2o_tot + lcv_n2o_tot + mc_n2o_tot + hcv_n2o_tot + bus_n2o_tot

/*CO*/
lpv_co_tot= rowsum(lpv_co)
lcv_co_tot= rowsum(lcv_co)
mc_co_tot= rowsum(mc_co)
hcv_co_tot= rowsum(hcv_co)
bus_co_tot= rowsum(bus_co)
co_total = lpv_co_tot + lcv_co_tot + mc_co_tot + hcv_co_tot + bus_co_tot

/*NOx*/
lpv_nox_tot= rowsum(lpv_nox)
lcv_nox_tot= rowsum(lcv_nox)
mc_nox_tot= rowsum(mc_nox)
hcv_nox_tot= rowsum(hcv_nox)
bus_nox_tot= rowsum(bus_nox)
nox_total = lpv_nox_tot + lcv_nox_tot + mc_nox_tot + hcv_nox_tot + bus_nox_tot

/*NMVOC*/
lpv_nmvoc_tot= rowsum(lpv_nmvoc)
lcv_nmvoc_tot= rowsum(lcv_nmvoc)
mc_nmvoc_tot= rowsum(mc_nmvoc)
hcv_nmvoc_tot= rowsum(hcv_nmvoc)
bus_nmvoc_tot= rowsum(bus_nmvoc)
nmvoc_total = lpv_nmvoc_tot + lcv_nmvoc_tot + mc_nmvoc_tot + hcv_nmvoc_tot + bus_nmvoc_tot

/*SO2*/
lpv_so2_tot= rowsum(lpv_so2)
lcv_so2_tot= rowsum(lcv_so2)
mc_so2_tot= rowsum(mc_so2)
hcv_so2_tot= rowsum(hcv_so2)
bus_so2_tot= rowsum(bus_so2)
so2_total = lpv_so2_tot + lcv_so2_tot + mc_so2_tot + hcv_so2_tot + bus_so2_tot

/** TAX REVENUE AGGREGATES*/
tax_tot = lpv_tax_tot + lcv_tax_tot + mc_tax_tot + hcv_tax_tot + bus_tax_tot
tax_tot_r = tax_tot:/cpi_proj[IL_vkt-10..rows(cpi_proj)]
tax_plus_ets_tot = tax_tot + ets_cost_tot
tax_plus_ets_tot_r = tax_tot_r +ets_cost_tot_r
revenue = (tax_plus_ets_tot, tax_plus_ets_tot_r, tax_tot, tax_tot_r)

/***Pad shortened output series with zeros to make them full length*/
hcv_vkt_total = (J(Time_length - TL_vkt,1,0)\hcv_vkt_total)
bus_vkt_total = (J(Time_length - TL_vkt,1,0)\bus_vkt_total)
co2_total = (J(Time_length - TL_vkt,1,0)\co2_total)
tax_tot_r = (J(Time_length - TL_vkt,1,0)\tax_tot_r)
end
*End